<?php
/*#################################################################################
	AdLogger
	- An open-source tracking tool for preventing click fraud

	Copyright 2006 by Trevor Fitzgerald
	http://www.adlogger.org

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	If you find this script useful, please share it with others!

	Thank you!
*/#################################################################################

// Function to get the visitor's IP address
function visitorIP() {
	if (getenv("REMOTE_ADDR")) {
		$ip = getenv("REMOTE_ADDR");
	} else {
		$ip = $_SERVER['REMOTE_ADDR'];
	}

	$ip = mysql_real_escape_string(htmlentities($ip));
	return $ip;
}

// Function to see if the user is using any proxies
function extra_IP_info() {
	$extrainfo = '';
	if (getenv("HTTP_CLIENT_IP")) {
		$extrainfo = "HTTP_CLIENT_IP: " . getenv("HTTP_CLIENT_IP");
	}

	if (getenv("HTTP_X_FORWARDED_FOR")) {
		if (!empty($extrainfo)) $extrainfo .= "; ";
		$extrainfo .= "HTTP_X_FORWARDED_FOR: " . getenv("HTTP_X_FORWARDED_FOR");
	}

	$extrainfo = mysql_real_escape_string(htmlentities($extrainfo));
	return $extrainfo;
}

// This function will grab the variables passed via the URL from the javascript page
function grab_from_url($value) {
	$value = mysql_real_escape_string(htmlentities($_GET["$value"]));
	return $value;
}

/*
Checks to see if a given IP address starts with
any of the same IP addresses/ranges that are banned.
*/
function ban_ip_range($ip_address, $range_to_ban) {
	return (strncmp($ip_address, $range_to_ban, strlen($range_to_ban)) == 0);
}

/*
If the display page URL contains any combination of "http://", "https://", or "www.",
the script will throw those out.  This way, it saves room in the database and it
doesn't count "http://example.com" and "http://www.example.com" as 2 separate pages
when it's really the same page.
Also, does the same if a page ends in index.php or index.html
*/
function get_disp_page($ref) {
	if (preg_match("/^(https*:\/\/)*(www\.)*/", $ref)) {
		$ref = preg_replace("/^(https*:\/\/)*(www\.)*/", '', $ref);
	}
	if (preg_match("/\/index.([a-zA-Z0-9_]{2,4})$/", $ref)) {
		$ref = preg_replace("/\/index.([a-zA-Z0-9_]{2,4})$/", '', $ref);
	}
	$ref = mysql_real_escape_string(urldecode($ref));
	return $ref;
}
?>